import json
import requests

def fetch_data_from_url(url):
    # 获取JSON数据
    response = requests.get(url)
    return response.json()

def convert_data(original_data):
    converted_data = []

    for key, value in original_data.items():
        name = key
        type_ = value['type']
        items = []

        for item in value['container']:
            # 将 icon 和 text 转为 key 和 val
            items.append({"key": item['text'], "val": item['icon']})

        converted_data.append({
            'name': name,
            'type': type_,
            'items': items
        })

    return converted_data

def save_data_to_file(data, filename):
    with open(filename, 'w', encoding='utf-8') as f:
        json.dump(data, f, ensure_ascii=False, indent=2)

if __name__ == "__main__":
    # 假设你的网络地址
    url = 'https://blog.liushen.fun/config/etc/owo.json'  # 这里替换成实际的URL

    # 1. 从网络获取数据
    original_data = fetch_data_from_url(url)

    # 2. 转换数据格式
    converted_data = convert_data(original_data)

    # 3. 保存转换后的数据到本地文件
    save_data_to_file(converted_data, 'converted_owo.json')

    print("数据转换完成，并已保存为 './converted_owo.json'")

# 注意图片格式的表情包请自行批量替换掉img的html标签格式，vs code即可实现