import {
    defineConfig
} from 'swpp-backends'

defineConfig({
    compilationEnv: {
        DOMAIN_HOST: new URL('https://blog.liushen.fun'), 
        SERVICE_WORKER: "sw",
        JSON_HTML_LIMIT: 10,
        // isStable: (url: URL) => {
        //     return [
        //         /^(https?:\/\/|\/\/)(cdn|fastly)\.jsdelivr\.net\/npm\/.*@\d+\.\d+\.\d+\//,
        //         /^(https?:\/\/|\/\/)jsd\.liiiu\.cn\/.*@\d+\.\d+\.\d+\//,
        //         /^(https?:\/\/|\/\/)cdn\.jsdmirror\.com\/.*@\d+\.\d+\.\d+\//,
        //         /^(https?:\/\/|\/\/)cdn\.staticfile\.org\/.*\/\d+\.\d+\.\d+\//,
        //         /^(https?:\/\/|\/\/)lf\d+-cdn-tos\.bytecdntp\.com\/.*\/\d+\.\d+\.\d+\//,
        //         /^(https?:\/\/|\/\/)npm\.elemecdn\.com\/.*@\d+\.\d+\.\d+\//
        //     ].some(it => it.test(url.href))
        // },
        VERSION_LENGTH_LIMIT: 256,
        // NETWORK_FILE_FETCHER: {
        //     referer: "https://blog.liushen.fun",
        //     getStandbyList(url: string | URL): (string | URL)[] {
        //         if (typeof url === 'string') url = new URL(url)
        //         if (url.hostname === 'npm.elemecdn.com') {
        //             return [`https://fastly.jsdelivr.net${url.pathname}`]
        //         }
        //         return [url]
        //     }
        // }
    },

    domConfig: {
        onSuccess: () => {
            caches
                .match("https://id.v3/")
                .then((res) => {
                    if (res) {
                        res.json().then((json) => {
                            btf && btf.snackbarShow(`已自动刷新SW缓存，当前版本为 v${json.escape + '.' + '0' + '.' + json.global + '.' + json.local} ，如果不生效，请尝试刷新页面以获取最新内容。`);
                        });
                    } else {
                        console.warn("未找到版本信息缓存，可能是第一次访问或缓存已过期");
                    }
                }).catch((err) => console.warn("获取版本信息缓存失败", err));
        }
    },

    crossEnv: {
        CACHE_NAME: "BlogCache",
        VERSION_PATH: "https://id.v3/",
        ESCAPE: 15,
    },

    runtimeDep: {
        getStandbyRequests: (request: Request): {t: number, l: () => Request[]} | void => {
            const srcUrl = request.url
            const {host, pathname} = new URL(srcUrl)
            // noinspection SpellCheckingInspection
            const commonCdnList = ['jsd.liiiu.cn', 'cdn.jsdmirror.com', 'fastly.jsdelivr.net']
            // noinspection SpellCheckingInspection
            const elme = 'npm.elemecdn.com'
            const urlMapper = (it: string) => new Request(it, request)
            if (host === elme) {
                return {
                    t: 2000,
                    l: () => [...commonCdnList.map(it => `https://${it}/npm${pathname}`)].map(urlMapper)
                }
            }
            if (host === 'jsd.liiiu.cn') {
                commonCdnList.splice(0, 1)
                return {
                    t: 2000,
                    l: () => [...commonCdnList.map(it => `https://${it}${pathname}`)].map(urlMapper)
                }
            }
        }
    },

    crossDep: {
        matchCacheRule: {
            runOnBrowser: (url: URL)  => {
                let { host, pathname } = url;

                // 处理省略index.html的情况
                if (pathname.endsWith('/')) pathname += 'index.html';

                // 仅仅对于blog.liushen.fun 处理 html 和 json
                if (host.endsWith('blog.liushen.fun')) {
                    if (pathname.endsWith('.json')) return 3600000; // 1 hour
                    if (pathname.endsWith('.html')) return false; // 暂不缓存
                    if (pathname.endsWith('.webp') || pathname.endsWith('.jpg') || pathname.endsWith('.png')) return 432000000; // 5 days
                }
                if (/\.(js|css|woff2|woff|ttf|cur)$/.test(url.pathname)) return 864000000; // 10 days
                
                // return ((url.host.endsWith('blog.liushen.fun') && /(\/|\.json)$/.test(url.pathname)) || /\.(js|css|woff2|woff|ttf|cur)$/.test(url.pathname)) ? 86400000 : false
            },
            runOnNode(url: URL) {
                // @ts-ignore
                return this.runOnBrowser(url)
            }
        }
    },
})