import os
import json
from tencentcloud.common import credential
from tencentcloud.teo.v20220901 import teo_client, models
from tencentcloud.common.exception.tencent_cloud_sdk_exception import TencentCloudSDKException

try:
    cred = credential.Credential(
        os.getenv("TENCENTCLOUD_SECRET_ID"),
        os.getenv("TENCENTCLOUD_SECRET_KEY")
    )
    client = teo_client.TeoClient(cred, "")

    req = models.CreatePurgeTaskRequest()
    req.from_json_string(json.dumps({
        "ZoneId": "zone-*************",
        "Type": "purge_prefix",
        "Targets": [
            "https://blog.liushen.fun/"
        ]
    }))

    resp = client.CreatePurgeTask(req)
    print(resp.to_json_string(indent=2))

except TencentCloudSDKException as err:
    print("刷新失败:", err)
