## Hexo 自定义 About 页面说明

本项目修改自 Hexo 博客主题 `liushen`，用于添加自定义的 About 页面，包含数据、模板与样式支持。

### 修改说明

#### 1. 创建数据文件

创建 `[blogroot]/source/_data/about.yml`
用于定义 About 页面所需的数据内容（如个人简介、联系方式等）。

---

#### 2. 修改页面布局逻辑

编辑 `[blogroot]/themes/liushen/layout/page.pug` 文件，添加如下内容以接入自定义模板：

```pug
when 'about'
    include includes/page/about.pug
```

注意不要完全按照本站，复制粘贴，可能会出现问题，下方文件仅供示例。

---

#### 3. 添加 Pug 模板

创建 `[blogroot]/themes/liushen/layout/includes/page/about.pug`
该文件将根据 `about.yml` 数据渲染对应页面内容，支持自定义结构和排版。

---

#### 4. 添加样式文件

创建 `[blogroot]/themes/liushen/source/css/_page/about.styl`
用于为 About 页面提供独立样式，按需定义页面布局、字体样式等。

---

### 使用说明

* 配置 `_config.yml` 中的 `menu` 项添加 `about` 页面入口；
* 在 `about.yml` 中填入所需数据；
* 修改 `about.pug` 与 `about.styl` 来实现所需视觉样式和页面布局。

---

完整代码请看当前gist中其余文件
