/**
 * Welcome to Cloudflare Workers! This is your first worker.
 *
 * - Run "npm run dev" in your terminal to start a development server
 * - Open a browser tab at http://localhost:8787/ to see your worker in action
 * - Run "npm run deploy" to publish your worker
 *
 * Learn more at https://developers.cloudflare.com/workers/
 */


export default {
  async fetch(request, env, ctx) {
    const GITHUB_TOKEN = 'github_pat_11AW00000000000000_1008DVkF0000000000AWi0031J0000000000Wm1eG700Li0000000000GgCm00000000000'; // 你的 GitHub Token
    const GITHUB_API_URL = 'https://api.github.com/repos';

    const url = new URL(request.url);
    const repoName = url.searchParams.get('repo') || 'liushen-blog'; // 默认使用 'liushen-blog' 仓库
    const dataCount = parseInt(url.searchParams.get('count')) || 10; // 默认返回 10 条数据

    const commitsUrl = `${GITHUB_API_URL}/willow-god/${repoName}/commits?per_page=${dataCount}`;

    try {
      // 请求 GitHub API 获取提交数据
      const response = await fetch(commitsUrl, {
        method: 'GET',
        headers: {
          'Accept': 'application/vnd.github+json',
          'Authorization': `Bearer ${GITHUB_TOKEN}`,
          'X-GitHub-Api-Version': '2022-11-28',
          'User-Agent': 'Cloudflare Worker' // 添加 User-Agent 头部
        }
      });

      if (!response.ok) {
        const errorText = await response.text();
        console.error(`GitHub API Error: ${errorText}`);
        return new Response('Error fetching commits from GitHub', { status: response.status });
      }

      const commits = await response.json();
      const result = commits.map(commit => ({
        sha: commit.sha,
        date: commit.commit.author.date,
        message: commit.commit.message
      }));

      return new Response(JSON.stringify(result, null, 2), {
        headers: { 'Content-Type': 'application/json' }
      });

    } catch (err) {
      console.error('Error fetching commits:', err);
      return new Response('Error fetching commits', { status: 500 });
    }
  }
};


