## 🎵 音乐胶囊模块使用说明

本仓库提供了一个可集成到 Hexo 主题 **liushen** 的音乐胶囊播放器模块。模块包含四个主要部分：

* **主题配置文件**
* **布局模板文件**
* **样式文件**
* **前端脚本**

本文档将详细介绍它们的放置位置、引用方式和变量配置。

---

### 1️⃣ 配置文件（根目录）

**文件：** `_config.liushen.yml`
**位置：** 项目根目录（`blog/_config.liushen.yml`），**不是主题根目录**。

该文件用于存放音乐模块的相关配置（如是否启用、播放列表、API 接口等）。
示例（按需调整）：

```yaml
# 页脚音乐胶囊
capsule:
  enable: true
  # 歌单 ID / 单曲 ID
  id: 13597135963
  # 服务商：netease / qq / xiami / kugou / baidu
  server: netease
  # 类型：playlist / song
  type: playlist
  meting_api: https://met.example.com/api?server=:server&type=:type&id=:id&r=:r
  volume: 0.8
```

---

### 2️⃣ 布局模板文件

**文件：** `music.pug`
**位置：** `blog/themes/liushen/layout/includes/third-party/music.pug`

该文件用于渲染音乐胶囊播放器 UI，需要在 `layout.pug` 中手动引入。

在 `blog/themes/liushen/layout/includes/layout.pug` **底部** 添加以下代码（保留现有内容，仅在末尾追加）：

```pug
if theme.capsule && theme.capsule.enable
  include ./third-party/music.pug
```

> 📌 该判断会根据 `_config.liushen.yml` 中的 `capsule.enable` 来决定是否加载播放器。

---

### 3️⃣ 样式文件

**文件：** `music-capsule.styl`
**位置：** `blog/themes/liushen/source/css/__layout/music-capsule.styl`

该位置的`styl`样式表会被自动整合到`main.css`

#### 💡 样式变量对照表

音乐胶囊使用了一些 CSS 变量，这些变量在亮色与暗色模式下分别定义。

##### 🌞 亮色模式（默认）

```css
/* nav */
--liushen-nav-bg: rgba(255, 255, 255, 0.8);
--liushen-nav-shadow: rgba(133, 133, 133, 0.6) 0px 5px 6px -5px;

/* ai_summary */
--liushen-title-font-color: #0883b7;
--liushen-maskbg: rgba(255, 255, 255, 0.85);
--liushen-ai-bg: conic-gradient(from 1.5708rad at 50% 50%, #d6b300 0%, #42A2FF 54%, #d6b300 100%);

/* card */
--liushen-card-bg: #fff;
--liushen-card-secondbg: #f1f3f8;
--liushen-card-border: 1px solid #e3e8f7;

/* button */
--liushen-button-bg: #f1f3f8;
--liushen-button-hover-bg: $theme-color;

/* text */
--liushen-text: #4c4948;
--liushen-secondtext: #3c3c43cc;

/* snackbar */
--snackbar-bg: rgba(255, 255, 255, 0.809);
--snackbar-text: #4c4948;
--snackbar-border: 1px solid rgba(126, 126, 126, 0.527);

/* menu child */
--menu-child-bg: rgba(255,255,255,0.8);

/* fancybox */
--liushen-fancybox-bg: rgba(255,255,255,0.5);
--liushen-fancybox-button-color: #000000;
```

##### 🌙 暗色模式

```css
[data-theme='dark'] {
  /* nav */
  --liushen-nav-bg: rgba(18,18,18,.8);
  --liushen-nav-shadow: rgba(133, 133, 133, 0) 0px 5px 6px -5px;

  /* ai_summary */
  --liushen-maskbg: rgba(0, 0, 0, 0.85);
  --liushen-ai-bg: conic-gradient(from 1.5708rad at 50% 50%,rgba(214, 178, 0, 0.46) 0%,rgba(66, 161, 255, 0.53) 54%,rgba(214, 178, 0, 0.49) 100%);

  /* card */
  --liushen-card-bg: #2d2d2d;
  --liushen-card-secondbg: #3e3f41;
  --liushen-card-border: 1px solid #42444a;

  /* button */
  --liushen-button-bg: #30343f;
  --liushen-button-hover-bg: $theme-color;

  /* text */
  --liushen-text: #ffffffb3;
  --liushen-secondtext: #a1a2b8;

  /* snackbar */
  --snackbar-bg: rgba(48, 48, 48, 0.809);
  --snackbar-text: #dfdfdf;
  --snackbar-border: 1px solid #cfd4dc40;

  /* menu child */
  --menu-child-bg: rgba(18,18,18,0.8);

  /* fancybox */
  --liushen-fancybox-bg: rgba(0,0,0,0.5);
  --liushen-fancybox-button-color: #ffffff;
}
```

> 你可以将这些变量整合到主题的全局变量文件中，或根据配色需求自行调整。

---

### 4️⃣ 前端脚本

**文件：** `music.js`
**位置：** 可放在主题的任意 JS 文件中（例如 `blog/themes/liushen/source/js/music.js`）或合并到 `main.js` 中。

### 引入方式一（单独文件）

在主题 `layout.pug` 的底部或 `additional-js.pug` 中添加：

```pug
script(src='/js/music.js')
```

#### 引入方式二（合并代码）

将 `music.js` 中的代码直接复制到 `main.js` 或其他已加载的脚本文件中。

---

### 🔗 集成流程总结

1. 将 `_config.liushen.yml` 添加到 **项目根目录** 并配置 `capsule.enable: true`。
2. 将 `music.pug` 放入 `blog/themes/liushen/layout/includes/third-party/`。
3. 编辑 `layout.pug`，在底部添加 `include ./third-party/music.pug`（带条件判断）。
4. 将 `music-capsule.styl` 放入 `blog/themes/liushen/source/css/__layout/`。
5. 将 `music.js` 放入 JS 目录并在页面加载时引入，或者可以添加到任意js文件中。
6. 根据需要修改 CSS 变量配色。