#!/bin/bash

# ============================
# 创建一个 4GB 的 Swap 文件
# ============================

# 步骤 1：创建 4GB 的 Swap 文件
echo "步骤 1：创建 4GB 的 Swap 文件"

# 使用 fallocate 创建一个 4GB 的 swap 文件
echo "创建 swap 文件..."
sudo fallocate -l 4G /swapfile

# 如果 fallocate 不可用，使用 dd 创建 swap 文件（备选方法）
# echo "使用 dd 创建 swap 文件..."
# sudo dd if=/dev/zero of=/swapfile bs=1M count=4096

# 设置 swap 文件权限为 600，确保只有 root 用户可以访问
echo "设置文件权限为 600..."
sudo chmod 600 /swapfile

# 使用 mkswap 格式化文件为 swap 空间
echo "格式化为 swap 空间..."
sudo mkswap /swapfile

# 启用 swap 文件
echo "启用 swap 文件..."
sudo swapon /swapfile

# ============================
# 配置系统使 Swap 文件在重启后自动启用
# ============================

echo "步骤 2：配置系统使 Swap 文件在重启后自动启用"

# 修改 /etc/fstab 文件，确保重启后 swap 自动启用
echo "修改 /etc/fstab 文件以启用 swap..."
echo "/swapfile none swap sw 0 0" | sudo tee -a /etc/fstab

# ============================
# 调整 vm.swappiness 设置
# ============================

echo "步骤 3：调整 vm.swappiness 设置"

# 临时修改 vm.swappiness 参数
echo "临时修改 vm.swappiness 为 60..."
sudo sysctl vm.swappiness=60

# 永久修改 vm.swappiness 设置，编辑 /etc/sysctl.conf
echo "编辑 /etc/sysctl.conf 文件以永久设置 vm.swappiness..."
echo "vm.swappiness=60" | sudo tee -a /etc/sysctl.conf

# 使配置生效
echo "使配置生效..."
sudo sysctl -p

# ============================
# 验证 Swap 文件是否启用
# ============================

echo "步骤 4：验证 Swap 文件是否启用"

# 使用 free 命令查看系统内存和 swap 状态
echo "查看当前内存和 swap 状态..."
free -h

# ============================
# 检查 Swap 状态
# ============================

echo "步骤 5：检查 Swap 状态"

# 使用 swapon --show 查看当前启用的 swap 文件
echo "显示当前启用的 swap 文件..."
swapon --show

echo "脚本执行完毕！"
